<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Produk_model extends CI_Model
{
	public $table = 't_produk';
	public $id = 'id_produk';
	public $kode = 'kode';

	function __construct()
	{
		parent::__construct();
	}

    function get_all(){
        $query = "SELECT
                a.id_produk,
                a.nama as nama_produk,
                a.slug,
                a.deskripsi,
                a.penulis,
                a.gambar,
                a.gambar2,
                a.harga,
                a.diskon,
                b.nama as nama_admin,
                c.nama as nama_kategori
                FROM
                t_produk a
                JOIN m_user b ON a.createdBy = b.id_user 
                LEFT JOIN m_kategori c ON a.id_kategori = c.id_kategori
                WHERE a.active=? ORDER BY a.id_produk DESC;";
        $binding = [1];
        $Q = $this->db->query($query, $binding);
        return $Q->result(); //return $query->result_array();
    }

	function get_limit($limit, $start){
        $query = "SELECT
        		a.nama as nama_produk,
                a.slug,
        		a.deskripsi,
        		a.penulis,
        		a.gambar,
        		a.harga,
        		a.diskon,
        		b.nama as nama_admin
                FROM
                t_produk a
                JOIN m_user b ON a.createdBy = b.id_user 
                WHERE a.active=? ORDER BY a.id_produk DESC LIMIT $limit OFFSET $start;";
        $binding = [1];
        $Q = $this->db->query($query, $binding);
        return $Q->result(); //return $query->result_array();
    }

    function get_limit_keyword($limit, $start, $keyword, $urutharga){

        $query = "SELECT
                a.nama as nama_produk,
                a.slug,
                a.deskripsi,
                a.penulis,
                a.gambar,
                a.harga,
                a.diskon,
                b.nama as nama_admin
                FROM
                t_produk a
                JOIN m_user b ON a.createdBy = b.id_user 
                WHERE a.active=? AND (a.nama LIKE ? OR a.penulis LIKE ?) ORDER BY CAST(a.harga AS DECIMAL(10,2)) $urutharga LIMIT $limit OFFSET $start;";
        $binding = [1,$keyword,$keyword];
        $Q = $this->db->query($query, $binding);
        return $Q->result(); //return $query->result_array();
    }

    // Tampilkan seluruh produk untuk halaman id_kategori
    function get_limit_kategori($limit, $start, $id){
        $query = "SELECT
                a.nama as nama_produk,
                a.slug,
                a.deskripsi,
                a.penulis,
                a.gambar,
                a.harga,
                a.diskon,
                b.nama as nama_admin
                FROM
                t_produk a
                JOIN m_user b ON a.createdBy = b.id_user 
                WHERE a.active=? AND a.id_kategori = ? ORDER BY a.id_produk DESC LIMIT $limit OFFSET $start;";
        $binding = [1, $id];
        $Q = $this->db->query($query, $binding);
        return $Q->result(); //return $query->result_array();
    }

    function get_limit_keyword_kategori($limit, $start, $keyword, $urutharga, $id){

        $query = "SELECT
                a.nama as nama_produk,
                a.slug,
                a.deskripsi,
                a.penulis,
                a.gambar,
                a.harga,
                a.diskon,
                b.nama as nama_admin
                FROM
                t_produk a
                JOIN m_user b ON a.createdBy = b.id_user 
                WHERE a.active=? AND (a.nama LIKE ? OR a.penulis LIKE ?)  AND a.id_kategori = ? ORDER BY CAST(a.harga AS DECIMAL(10,2)) $urutharga LIMIT $limit OFFSET $start;";
        $binding = [1,$keyword,$keyword, $id];
        $Q = $this->db->query($query, $binding);
        return $Q->result(); //return $query->result_array();
    }
    // Tampilkan seluruh produk untuk halaman id_kategori

    function select_id($id){
        $query = "SELECT
                *
                FROM
                $this->table
                WHERE
                $this->id = ?";
        $binding = [$id];
        $Q = $this->db->query($query, $binding);
        return $Q->row();
    }

    function SelectWhere($where){
        return $this->db->get_where($this->table, $where);
    }

    function insert($input){
        $action = $this->db->insert($this->table, $input);
        return $action;
    }

    function update($id,$input){
        $this->db->where($this->id,$id);
        $action = $this->db->update($this->table, $input);
        return $action;
    }
}
