<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Order_model extends CI_Model
{
	public $table = 't_order';
    public $table2 = 't_order_detail';
	public $id = 'id_order';
	public $kode = 'invoice';

	function __construct()
	{
		parent::__construct();
	}

    function get_all(){
    $query = "SELECT
                a.id_order,
                a.invoice,
                a.waktu,
                a.status,
                sum(b.jumlah * b.harga) as tot,
                a.ongkir
                FROM
                $this->table a
                JOIN t_order_detail b ON a.id_order = b.id_order
                GROUP BY a.id_order
                ORDER BY a.id_order DESC";
        $binding = [];
        $Q = $this->db->query($query, $binding);
        return $Q->result();
    }

    function select_invoice($invoice){
    $query = "SELECT
                *
                FROM
                $this->table
                WHERE $this->kode = ?";
        $binding = [$invoice];
        $Q = $this->db->query($query, $binding);
        return $Q->row();
    }

    function select_id_order($id_order){
    $query = "SELECT
                *
                FROM
                $this->table
                WHERE $this->id = ?";
        $binding = [$id_order];
        $Q = $this->db->query($query, $binding);
        return $Q->result();
    }

    function select_id_order_detail($id_order){
    $query = "SELECT
                a.id_order,
                a.invoice,
                a.waktu,
                a.status,
                a.ongkir,
                a.nama_lengkap,
                a.notelp,
                b.jumlah,
                a.kurir,
                a.layanan,
                a.kecamatan,
                a.alamat,
                b.harga
                FROM
                $this->table a
                JOIN t_order_detail b ON a.id_order = b.id_order
                WHERE a.id_order = ?";
        $binding = [$id_order];
        $Q = $this->db->query($query, $binding);
        return $Q->row();
    }

    function select_all_detail($id_order){
    $query = "SELECT
                a.harga,
                a.jumlah,
                b.gambar,
                b.nama
                FROM
                t_order_detail a
                JOIN t_produk b ON a.id_produk = b.id_produk
                WHERE a.id_order = ?";
        $binding = [$id_order];
        $Q = $this->db->query($query, $binding);
        return $Q->result();
    }

    function add($input){
        $action = $this->db->insert($this->table, $input);
        $insertId = $this->db->insert_id();
        return $insertId;
    }

    function add_detail($input){
        $action = $this->db->insert($this->table2, $input);
        return $action;
    }
    
    function update($id,$input){
        $this->db->where($this->id,$id);
        $action = $this->db->update($this->table, $input);
        return $action;
    }

    function update_invoice($invoice,$input){
        $this->db->where('invoice',$invoice);
        $action = $this->db->update($this->table, $input);
        return $action;
    }
}
