<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed!');

class Breadcrumb {
	public $ci;
	
	public function __construct()
	{
		$this->ci = &get_instance();
	}

	public function generate()
	{
		$total_segments = $this->ci->uri->total_segments();

		$segments = [];
		
		for ($i=1; $i<=$total_segments; $i++){
			
			$url = base_url();

			$jml = $total_segments-$i;
				
			for ($a=$jml; $a<=$i; $a++) {
				$url .= $this->ci->uri->segment($a)."/";
			}
				
			$title =  ucwords(str_replace('-',' ' , $this->ci->uri->segment($i)));
			
			$segments[] = (object) array(
					'url' => $url,
					'title' => $title
			);
		}
		
		return $this->template($segments);
	}
	
	function template($segment, $optional_link = null)
	{
		
		$html = '<a href="'.base_url().'" style="color:#fff;text-decoration: underline;">Home</a>';
		
		for ($i=0; $i<count($segment); $i++) {
			if ($i == count($segment) - 1) {
				if ($segment[$i]->title!='Home') {
					$html .= ' / '.$segment[$i]->title;
				}
			}else{
				$html .= ' / <a href="'.$segment[$i]->url.'"  style="color:#fff;text-decoration: underline;">'.$segment[$i]->title.'</a>';
			}
			
		}
		
		if (!empty($optional_link)) {
			$html .= '<ul class="w-breadcrumb-right">';
			$html .= '<li><a href="'.$optional_link->url.'">'.$optional_link->text.'</a></li>';
			$html .= '</ul>';
		}
		
		return $html;
	}
}