<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// generate sql insert
function generateSqlInsert($table, $data) {
    // get keys
    $keys = array_keys($data);

    // get values
    $values = array_values($data);

    $sqlValues = str_repeat(',?', count($data));

    return array('sql'=> 'insert into '.$table.' ('.implode(',', $keys).') values ('.substr($sqlValues, 1).');', 'param'=> $values);
}

// generate sql insert multiple values
function generateSqlInsertBatch($table, $data) {
    $i = 0;
    $values = array();
    foreach($data as $header) {
        if ($i == 0) {
            // get keys
            $keys = array_keys($header);
            
            $b = str_repeat(',?', count($header));
            $c = '('.substr($b, 1).')';
        }

        // get values
        $values = array_merge($values, array_values($header));
        
        $i++;
    }

    $sqlVal = str_repeat(','.$c, count($data));

    return array('sql'=> 'insert into '.$table.' ('.implode(',', $keys).') values '.substr($sqlVal, 1).';', 'param'=> $values);
}

// generate sql update
function generateSqlUpdate($table, $data, $where){
    // get keys
    $keys['set'] = array_keys($data);
    $keys['where'] = array_keys($where);

    // get values
    $values = array_merge(array_values($data), array_values($where));

    return array('sql'=> 'update '.$table.' set '.implode('=?,', $keys['set']).'=? where '.implode('=? and ', $keys['where']).'=?', 'param'=> $values);
}