<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Transaksi extends MY_Controller{
	function __construct(){
		parent::__construct();
		if (isset($this->session->username) == false or $this->session->id_admin < 0) {
			redirect('adminstore/Auth');
		}
	}

	public function index(){
		$data['data'] = $this->Order_model->get_all();
		//main
		$data['title'] = 'Transaksi';
	    $data['alert'] = $this->session->flashdata('message');
		$data['contents'] = 'backend/transaksi/view';
		$this->load->view('backend/layout/template', $data);
	}

  public function detail($id){
    $data['data'] = $this->Order_model->select_id_order_detail($id);
    $data['data_detail'] = $this->Order_model->select_all_detail($id);
    //main
    $data['title'] = 'Transaksi';
      $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/transaksi/detail';
    $this->load->view('backend/layout/template', $data);
  }

	public function save($id){
      $this->form_validation->set_rules('status', 'Status', 'trim|required|xss_clean');

      if($this->form_validation->run() == FALSE){
          $msg = error_msg(validation_errors());
          $do = FALSE;
      }else{
          $do = TRUE;
      }

      $status = $this->input->post('status');

      if ($do) {

      $data = array(
                  'status' => $status
                );
      $proses = $this->Order_model->update($id, $data);

      if ($proses) {
        $msg = success_msg('Update berhasil!');
              $this->session->set_flashdata('message', $msg);
        redirect('adminstore/transaksi/detail/'.$id);
      }else{
        $msg = error_msg('Gagal ubah setting, pastikan data sudah benar!');
        $do = FALSE;
      }
      }

      if (!$do) {
            $this->session->set_flashdata('message', $msg);
            // log_history(current_url(), $msg);
            redirect('adminstore/transaksi/detail/'.$id);
        }
	}
}
