<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Settings extends MY_Controller{
	function __construct(){
		parent::__construct();
		if (isset($this->session->username) == false or $this->session->id_admin < 0) {
			redirect('adminstore/Auth');
		}
	}

	public function index(){
		$data['settings'] = $this->Setting_model->get_detail_by_id();
		//main
		$data['title'] = 'General Setting';
	   $data['alert'] = $this->session->flashdata('message');
		$data['contents'] = 'backend/settings/general';
		$this->load->view('backend/layout/template', $data);
	}

  public function homepage($letak=''){
    if ($letak == 'slider') {
      $data['contents'] = 'backend/settings/slider';
    }elseif ($letak == 'banner') {
      $data['contents'] = 'backend/settings/banner';
    }else{
      $data['contents'] = 'backend/settings/homepage';
    }

    $data['settings'] = $this->Setting_model->get_detail_by_id();
    //main
    $data['title'] = 'Homepage Setting';
    $data['alert'] = $this->session->flashdata('message');
    $this->load->view('backend/layout/template', $data);
  }

	public function save(){
      $this->form_validation->set_rules('nama_toko', 'Nama Toko', 'trim|required|xss_clean');
      $this->form_validation->set_rules('deskripsi_toko', 'Deskripsi Toko', 'trim|required');
      $this->form_validation->set_rules('notelp', 'No Telp', 'xss_clean|trim|required');
      $this->form_validation->set_rules('email', 'Email', 'valid_email|trim|required');
      $this->form_validation->set_rules('alamat', 'Alamat Toko', 'xss_clean|trim');
      $this->form_validation->set_rules('city_id', 'Kota Asal Pengiriman', 'trim|required|xss_clean');
      $this->form_validation->set_rules('api_rajaongkir', 'Api Raja Ongkir', 'trim|required|xss_clean');
      $this->form_validation->set_rules('link_fb', 'Link Facebook', 'trim|xss_clean');
      $this->form_validation->set_rules('link_ig', 'Link Instagram', 'trim|xss_clean');
      $this->form_validation->set_rules('link_tw', 'Link Twitter', 'trim|xss_clean');
      $this->form_validation->set_rules('link_lk', 'Link Linkdin', 'trim|xss_clean');
      $this->form_validation->set_rules('link_headerkiri', 'Link Cara Menerbitkan Buku', 'trim|xss_clean');
      $this->form_validation->set_rules('link_event', 'Link Event', 'trim|xss_clean');
      $this->form_validation->set_rules('link_about', 'Link About', 'trim|xss_clean');
      $this->form_validation->set_rules('link_promo', 'Link Promo', 'trim|xss_clean');
      $this->form_validation->set_rules('link_service', 'Link Layanan', 'trim|xss_clean');
      $this->form_validation->set_rules('link_faq', 'Link FAQ', 'trim|xss_clean');
      $this->form_validation->set_rules('link_policy', 'Link Policy', 'trim|xss_clean');
      $this->form_validation->set_rules('link_TOU', 'Link Term Of User', 'trim|xss_clean');
      
      if($this->form_validation->run() == FALSE){
          $msg = error_msg(validation_errors());
          $do = FALSE;
      }else{
          $do = TRUE;
      }

      $nama_toko = $this->input->post('nama_toko');
      $deskripsi_toko = $this->input->post('deskripsi_toko');
      $notelp = $this->input->post('notelp');
      $email = $this->input->post('email');
      $city_id = $this->input->post('city_id');
      $api_rajaongkir = $this->input->post('api_rajaongkir');
      $alamat = $this->input->post('alamat');
      $link_fb = $this->input->post('link_fb');
      $link_ig = $this->input->post('link_ig');
      $link_tw = $this->input->post('link_tw');
      $link_lk = $this->input->post('link_lk');
      $link_headerkiri = $this->input->post('link_headerkiri');
      $link_event = $this->input->post('link_event');
      $link_about = $this->input->post('link_about');
      $link_promo = $this->input->post('link_promo');
      $link_service = $this->input->post('link_service');
      $link_faq = $this->input->post('link_faq');
      $link_policy = $this->input->post('link_policy');
      $link_TOU = $this->input->post('link_TOU');

      if ($do) {

      $data = array(
                  'nama_toko' => $nama_toko,
                  'deskripsi_toko' => $deskripsi_toko,
                  'city_id' => $city_id,
                  'notelp' => $notelp,
                  'email' => $email,
                  'api_rajaongkir' => $api_rajaongkir,
                  'link_fb' => $link_fb,
                  'link_ig' => $link_ig,
                  'link_tw' => $link_tw,
                  'link_lk' => $link_lk,
                  'link_headerkiri' => $link_headerkiri,
                  'link_event' => $link_event,
                  'link_about' => $link_about,
                  'link_promo' => $link_promo,
                  'link_service' => $link_service,
                  'link_faq' => $link_faq,
                  'link_policy' => $link_policy,
                  'link_TOU' => $link_TOU,
                  'alamat' => $alamat
                );
      $proses = $this->Setting_model->update($data);

      if ($proses) {
        $msg = success_msg('Update berhasil!');
              $this->session->set_flashdata('message', $msg);
        redirect('adminstore/settings');
      }else{
        $msg = error_msg('Gagal ubah setting, pastikan data sudah benar!');
        $do = FALSE;
      }
      }

      if (!$do) {
            $this->session->set_flashdata('message', $msg);
            // log_history(current_url(), $msg);
            redirect('adminstore/settings');
        }
	}


  public function saveslider(){
      $number_of_files = sizeof($_FILES['gambar']['tmp_name']);
      $files = $_FILES['gambar'];
          $config['upload_path'] = './assets/source/img/img_settings/';
          $config['allowed_types']   = 'jpg|jpeg|png|JPG|JPEG|PNG';
          $config['max_size']             = 5000;
          $config['max_width']            = 1000;
          $config['min_width']            = 1000;
          $config['max_height']           = 380;
          $config['min_height']           = 380;
          for ($i=0; $i < $number_of_files; $i++) {
              $file_name = uniqid().'.png';
              $_FILES['gambar']['name'] = $files['name'][$i];
              $_FILES['gambar']['tmp_name'] = $files['tmp_name'][$i];
              $_FILES['gambar']['type'] = $files['type'][$i];
              $_FILES['gambar']['size'] = $files['size'][$i];
              $_FILES['gambar']['error'] = $files['error'][$i];
              $config['file_name'] = $file_name;
              $this->load->library('upload', $config);
              $this->upload->initialize($config);
              $proses = $this->upload->do_upload('gambar');
              $upload[] = $proses;
              if ($proses) {
              $slider = 'slider'.$i;
              $input = array(
                  $slider => $file_name
                  );
              $this->Setting_model->update($input);
              }
          }
        
          if ($upload[0]&&$upload[1]&&$upload[2]) {
              $msg = success_msg('Update berhasil!');
              $this->session->set_flashdata('message', $msg);
            redirect('adminstore/settings/homepage/slider');
          }else{
              $msg = error_msg('Gagal ubah setting, pastikan format sudah benar!');
              $this->session->set_flashdata('message', $msg);
            redirect('adminstore/settings/homepage/slider');
          }
  }

  public function savebanner(){
      $number_of_files = sizeof($_FILES['gambar']['tmp_name']);
      $files = $_FILES['gambar'];
          $config['upload_path'] = './assets/source/img/img_settings/';
          $config['allowed_types']   = 'jpg|jpeg|png|JPG|JPEG|PNG';
          $config['max_size']             = 5000;
          $config['max_width']            = 450;
          $config['min_width']            = 450;
          $config['max_height']           = 360;
          $config['min_height']           = 360;
          for ($i=0; $i < $number_of_files; $i++) {
              $file_name = uniqid().'.png';
              $_FILES['gambar']['name'] = $files['name'][$i];
              $_FILES['gambar']['tmp_name'] = $files['tmp_name'][$i];
              $_FILES['gambar']['type'] = $files['type'][$i];
              $_FILES['gambar']['size'] = $files['size'][$i];
              $_FILES['gambar']['error'] = $files['error'][$i];
              $config['file_name'] = $file_name;
              $this->load->library('upload', $config);
              $this->upload->initialize($config);
              $proses = $this->upload->do_upload('gambar');
              $upload[] = $proses;
              if ($proses) {
              $banner = 'banner'.$i;
              $input = array(
                  $banner => $file_name
                  );
              $this->Setting_model->update($input);
              }
          }
        
          if ($upload[0]&&$upload[1]&&$upload[2]) {
              $msg = success_msg('Update berhasil!');
              $this->session->set_flashdata('message', $msg);
            redirect('adminstore/settings/homepage/banner');
          }else{
              $msg = error_msg('Gagal ubah setting, pastikan format sudah benar!');
              $this->session->set_flashdata('message', $msg);
            redirect('adminstore/settings/homepage/banner');
          }
  }
}
