<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Produk extends MY_Controller{
	function __construct(){
		parent::__construct();
		if (isset($this->session->username) == false or $this->session->id_admin < 0) {
			redirect('adminstore/Auth');
		}
    $this->load->model('Produk_model');
    $this->load->model('Kategori_model');
	}

	public function index(){
		$data['data'] = $this->Produk_model->get_all();
		//main
		$data['title'] = 'Produk';
	  $data['alert'] = $this->session->flashdata('message');
		$data['contents'] = 'backend/produk/view';
		$this->load->view('backend/layout/template', $data);
	}

  // public function deleteimg(){
  //   $data['data'] = $this->Produk_model->get_all();
  //   foreach ($data['data'] as $key) {
  //     $awal = './assets/source/img/img_produk/'.$key->gambar;
  //     $tujuan = './assets/source/img/img_produk/img_kepake/'.$key->gambar2;
  //     if (file_exists($awal)) {
  //     if(copy($awal, $tujuan)){
  //       echo "Produk".$key->id_produk." Berhasil</br>";
  //     }else{
  //       echo "Produk".$key->id_produk." Gagal</br>";
  //     }
  //     echo  "Produk".$key->id_produk." File ada</br>";
  //     }
  //   }
  // }

   public function add(){
    $data['kategori'] = $this->Kategori_model->get_all();
    //main
    $data['title'] = 'Produk';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/produk/add';
    $this->load->view('backend/layout/template', $data);
  }

  public function detail($id){
    $data['data'] = $this->Produk_model->select_id($id);
    $data['kategori'] = $this->Kategori_model->get_all();
    //main
    $data['title'] = 'Produk';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/produk/detail';
    $this->load->view('backend/layout/template', $data);
  }

	public function save($id=''){
      $this->form_validation->set_rules('nama', 'Nama Produk', 'trim|required|xss_clean');
      $this->form_validation->set_rules('deskripsi', 'Deskripsi Produk', 'trim|required');
      $this->form_validation->set_rules('id_kategori', 'Deskripsi Produk', 'trim|required|xss_clean');
      $this->form_validation->set_rules('penulis', 'Penulis', 'trim|required|xss_clean');
      $this->form_validation->set_rules('gambar', 'Gambar 1', 'trim|xss_clean');
      $this->form_validation->set_rules('gambar2', 'Gambar 2', 'trim|xss_clean');
      $this->form_validation->set_rules('harga', 'Harga', 'trim|required|xss_clean');
      $this->form_validation->set_rules('diskon', 'Diskon', 'trim|xss_clean');
      $this->form_validation->set_rules('berat', 'Berat', 'trim|required|xss_clean');
      $this->form_validation->set_rules('editor', 'Berat', 'trim|xss_clean');
      $this->form_validation->set_rules('penata_letak', 'Berat', 'trim|xss_clean');
      $this->form_validation->set_rules('halaman', 'Berat', 'trim|required|xss_clean');
      $this->form_validation->set_rules('dimensi', 'Berat', 'trim|required|xss_clean');
      $this->form_validation->set_rules('isbn', 'Berat', 'trim|required|xss_clean');
      $this->form_validation->set_rules('eisbn', 'Berat', 'trim|required|xss_clean');
      
      if($this->form_validation->run() == FALSE){
          $msg = error_msg(validation_errors());
          $do = FALSE;
      }else{
          $do = TRUE;
      }

      $nama = $this->input->post('nama');
      $string=preg_replace('/[^a-zA-Z0-9 &%|{.}=,?!*()"-_+$@;<>]/', '', $nama);
      $trim=trim($string);
      $pre_slug = preg_replace("/[^ \w]+/", "", $trim);
      $pre_slug2 = strtolower(str_replace(" ", "-", $pre_slug));
      $pre_slug3 = $pre_slug2.'-'.substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 5);
      $slug = $pre_slug3.'.html';
      $deskripsi = $this->input->post('deskripsi');
      $id_kategori = $this->input->post('id_kategori');
      $penulis = $this->input->post('penulis');
      $gambar = $this->input->post('gambar');
      $gambar2 = $this->input->post('gambar2');
      $harga = $this->input->post('harga');
      $diskon = $this->input->post('diskon');
      $berat = $this->input->post('berat');
      $editor = $this->input->post('editor');
      $penata_letak = $this->input->post('penata_letak');
      $halaman = $this->input->post('halaman');
      $dimensi = $this->input->post('dimensi');
      $isbn = $this->input->post('isbn');
      $eisbn = $this->input->post('eisbn');

      if ($do) {

      if ($id == '') {
        $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

        $config['upload_path'] = './assets/source/img/img_produk/';
        $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
        $config['file_name'] = $new_filename.'.png';
        $config['max_size'] = 100000; //100MB

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('gambar')) {
          $msg = success_msg($this->upload->display_errors());
          $this->session->set_flashdata('message', $msg);
          redirect('adminstore/produk/add/');
        };
        $this->upload->do_upload('gambar2');

        $data = array(
                    'nama' => $nama,
                    'slug' => $slug,
                    'deskripsi' => $deskripsi,
                    'id_kategori' => $id_kategori,
                    'penulis' => $penulis,
                    'gambar' => $new_filename.'.png',
                    'gambar2' => $new_filename.'1.png',
                    'harga' => $harga,
                    'diskon' => $diskon,
                    'berat' => $berat,
                    'editor' => $editor,
                    'penata_letak' => $penata_letak,
                    'halaman' => $halaman,
                    'dimensi' => $dimensi,
                    'isbn' => $isbn,
                    'eisbn' => $eisbn,
                    'createdBy' => $this->session->id_admin
                  );
        $proses = $this->Produk_model->insert($data);
      }else{
      if ((empty($_FILES['gambar']['name']))&&(empty($_FILES['gambar2']['name']))) {
      $data = array(
                  'nama' => $nama,
                  'deskripsi' => $deskripsi,
                  'id_kategori' => $id_kategori,
                  'penulis' => $penulis,
                  'harga' => $harga,
                  'diskon' => $diskon,
                  'berat' => $berat,
                  'editor' => $editor,
                  'penata_letak' => $penata_letak,
                  'halaman' => $halaman,
                  'dimensi' => $dimensi,
                  'isbn' => $isbn,
                  'eisbn' => $eisbn,
                  'updateBy' => $this->session->id_admin
                );
      $proses = $this->Produk_model->update($id,$data);
      }else{
      $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

      $config['upload_path'] = './assets/source/img/img_produk/';
      $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
      $config['file_name'] = $new_filename.'.png';
      $config['max_size'] = 100000; //100MB

      $this->load->library('upload', $config);

      if (!$this->upload->do_upload('gambar')) {
        $msg = success_msg($this->upload->display_errors());
        $this->session->set_flashdata('message', $msg);
        if ($id == '') {
          redirect('adminstore/produk/add/');
        }else{
          redirect('adminstore/produk/detail/'.$id);
        }
      };
      $this->upload->do_upload('gambar2');

      $data = array(
                  'nama' => $nama,
                  'deskripsi' => $deskripsi,
                  'id_kategori' => $id_kategori,
                  'penulis' => $penulis,
                  'gambar' => $new_filename.'.png',
                  'gambar2' => $new_filename.'1.png',
                  'harga' => $harga,
                  'diskon' => $diskon,
                  'berat' => $berat,
                  'editor' => $editor,
                  'penata_letak' => $penata_letak,
                  'halaman' => $halaman,
                  'dimensi' => $dimensi,
                  'isbn' => $isbn,
                  'eisbn' => $eisbn,
                  'updateBy' => $this->session->id_admin
                );
      $proses = $this->Produk_model->update($id,$data);
      }
      }

      if ($proses) {
        $msg = success_msg('Update berhasil!');
        $this->session->set_flashdata('message', $msg);
        if ($id == '') {
          redirect('adminstore/produk/add/');
        }else{
          redirect('adminstore/produk/detail/'.$id);
        }
      }else{
        $msg = error_msg('Gagal ubah produk, pastikan data sudah benar!');
        $do = FALSE;
      }
      }

      if (!$do) {
            $this->session->set_flashdata('message', $msg);
            // log_history(current_url(), $msg);
            if ($id == '') {
              redirect('adminstore/produk/add/');
            }else{
              redirect('adminstore/produk/detail/'.$id);
            }
        }
	}

  public function archive($id){
    $data = array(
                  'active' => 0,
                  'deleteBy' => $this->session->id_admin,
                  'deleteDate' => date('YYYY-MM-DD hh:mm:ss')
                );
    $proses = $this->Produk_model->update($id,$data);

    if ($proses) {
      $msg = success_msg('Berhasil memindahkan produk ke arsip!');
    }else{
      $msg = error_msg('Gagal memindahkan produk ke arsip, pastikan data sudah benar!');
      $do = FALSE;
    }

    $this->session->set_flashdata('message', $msg);
    redirect('adminstore/produk');
  }
}
