<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Kategori extends MY_Controller{
	function __construct(){
		parent::__construct();
		if (isset($this->session->username) == false or $this->session->id_admin < 0) {
			redirect('adminstore/Auth');
		}
    $this->load->model('Kategori_model');
	}

	public function index(){
		$data['data'] = $this->Kategori_model->get_all();
		//main
		$data['title'] = 'Kategori';
	  $data['alert'] = $this->session->flashdata('message');
		$data['contents'] = 'backend/kategori/view';
		$this->load->view('backend/layout/template', $data);
	}

  public function detail($id){
    $data['data'] = $this->Kategori_model->select_id($id);
    //main
    $data['title'] = 'Kategori';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/kategori/detail';
    $this->load->view('backend/layout/template', $data);
  }

   public function add(){
    $data['kategori'] = $this->Kategori_model->get_all();
    //main
    $data['title'] = 'Produk';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/kategori/add';
    $this->load->view('backend/layout/template', $data);
  }

	public function save($id=''){
      $this->form_validation->set_rules('nama', 'Nama Kategori', 'trim|required|xss_clean');
      $this->form_validation->set_rules('deskripsi', 'Deskripsi Kategori', 'trim|required');
      // $this->form_validation->set_rules('gambar', 'Gambar Banner', 'trim|xss_clean');

      if($this->form_validation->run() == FALSE){
          $msg = error_msg(validation_errors());
          $do = FALSE;
      }else{
          $do = TRUE;
      }

      $nama = $this->input->post('nama');
      $deskripsi = $this->input->post('deskripsi');
      $gambar = $this->input->post('gambar');

      if ($do) {

      if ($id == '') {
        // $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        // $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

        // $config['upload_path'] = './assets/source/img/img_kategori/';
        // $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
        // $config['file_name'] = $new_filename.'.png';
        // $config['max_size'] = 100000; //100MB

        // $this->load->library('upload', $config);

        // if (!$this->upload->do_upload('gambar')) {
          // $msg = success_msg($this->upload->display_errors());
          // $this->session->set_flashdata('message', $msg);
          // redirect('adminstore/kategori/add/');
        // };

        $data = array(
                    'nama' => $nama,
                    'deskripsi' => $deskripsi,
                    // 'banner' => $new_filename.'.png',
                    'createdBy' => $this->session->id_admin
                  );
        $proses = $this->Kategori_model->insert($data);
      }else{
      // if (empty($_FILES['gambar']['name'])) {
      $data = array(
                  'nama' => $nama,
                  'deskripsi' => $deskripsi,
                  'updateBy' => $this->session->id_admin
                );
      $proses = $this->Kategori_model->update($id,$data);
      // }else{
      // $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      // $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

      // $config['upload_path'] = './assets/source/img/img_kategori/';
      // $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
      // $config['file_name'] = $new_filename.'.png';
      // $config['max_size'] = 100000; //100MB

      // $this->load->library('upload', $config);

      // if (!$this->upload->do_upload('gambar')) {
      //   $msg = success_msg($this->upload->display_errors());
      //   $this->session->set_flashdata('message', $msg);
      //   if ($id == '') {
      //     redirect('adminstore/kategori/add/');
      //   }else{
      //     redirect('adminstore/kategori/detail/'.$id);
      //   }
      // };
      // $this->upload->do_upload('gambar2');

      // $data = array(
      //             'nama' => $nama,
      //             'deskripsi' => $deskripsi,
      //             'banner' => $new_filename.'.png',
      //             'updateBy' => $this->session->id_admin
      //           );
      // $proses = $this->Kategori_model->update($id,$data);
      // }
      }

      if ($proses) {
        $msg = success_msg('Update berhasil!');
        $this->session->set_flashdata('message', $msg);
        if ($id == '') {
          redirect('adminstore/kategori/add/');
        }else{
          redirect('adminstore/kategori/detail/'.$id);
        }
      }else{
        $msg = error_msg('Gagal ubah kategori, pastikan data sudah benar!');
        $do = FALSE;
      }
      }

      if (!$do) {
            $this->session->set_flashdata('message', $msg);
            // log_history(current_url(), $msg);
            if ($id == '') {
              redirect('adminstore/kategori/add/');
            }else{
              redirect('adminstore/kategori/detail/'.$id);
            }
        }
	}

  public function archive($id){
    $data = array(
                  'active' => 0,
                  'deleteBy' => $this->session->id_admin,
                  'deleteDate' => date('YYYY-MM-DD hh:mm:ss')
                );
    $proses = $this->Kategori_model->update($id,$data);

    if ($proses) {
      $msg = success_msg('Berhasil memindahkan kategori ke arsip!');
    }else{
      $msg = error_msg('Gagal memindahkan kategori ke arsip, pastikan data sudah benar!');
      $do = FALSE;
    }

    $this->session->set_flashdata('message', $msg);
    redirect('adminstore/kategori');
  }
}
