<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Blog extends MY_Controller{
	function __construct(){
		parent::__construct();
		if (isset($this->session->username) == false or $this->session->id_admin < 0) {
			redirect('adminstore/Auth');
		}
    $this->load->model('Blog_model');
	}

	public function index(){
		$data['data'] = $this->Blog_model->get_all();
		//main
		$data['title'] = 'Blog';
	  $data['alert'] = $this->session->flashdata('message');
		$data['contents'] = 'backend/blog/view';
		$this->load->view('backend/layout/template', $data);
	}

  public function detail($id){
    $data['data'] = $this->Blog_model->select_id($id);
    //main
    $data['title'] = 'Blog';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/Blog/detail';
    $this->load->view('backend/layout/template', $data);
  }

   public function add(){
    $data['Blog'] = $this->Blog_model->get_all();
    //main
    $data['title'] = 'Produk';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'backend/Blog/add';
    $this->load->view('backend/layout/template', $data);
  }

	public function save($id=''){
      $this->form_validation->set_rules('judul', 'Judul Blog', 'trim|required|xss_clean');
      $this->form_validation->set_rules('konten', 'Konten Blog', 'trim|required');
      // $this->form_validation->set_rules('gambar', 'Gambar Banner', 'trim|xss_clean');

      if($this->form_validation->run() == FALSE){
          $msg = error_msg(validation_errors());
          $do = FALSE;
      }else{
          $do = TRUE;
      }

      $judul = $this->input->post('judul');
      $konten = $this->input->post('konten');
      $string=preg_replace('/[^a-zA-Z0-9 &%|{.}=,?!*()"-_+$@;<>]/', '', $judul);
      $trim=trim($string);
      $pre_slug = preg_replace("/[^ \w]+/", "", $trim);
      $pre_slug2 = strtolower(str_replace(" ", "-", $pre_slug));
      $pre_slug3 = $pre_slug2.'-'.substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 5);
      $slug = $pre_slug3.'.html';

      if ($do) {

      $data = array(
                  'judul' => $judul,
                  'konten' => $konten,
                  'active' => 1,
                  'slug' => $slug,
                  // 'banner' => $new_filename.'.png',
                );

      if ($id == '') {
        // $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        // $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

        // $config['upload_path'] = './assets/source/img/img_Blog/';
        // $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
        // $config['file_name'] = $new_filename.'.png';
        // $config['max_size'] = 100000; //100MB

        // $this->load->library('upload', $config);

        // if (!$this->upload->do_upload('gambar')) {
          // $msg = success_msg($this->upload->display_errors());
          // $this->session->set_flashdata('message', $msg);
          // redirect('adminstore/Blog/add/');
        // };

        $data['createdBy'] = $this->session->id_admin;
        $proses = $this->Blog_model->insert($data);
      }else{
      // if (empty($_FILES['gambar']['name'])) {
      $data['updateBy'] = $this->session->id_admin;
      $data['updateDate'] = date('YYYY-MM-DD hh:mm:ss');
      $proses = $this->Blog_model->update($id,$data);
      // }else{
      // $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      // $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

      // $config['upload_path'] = './assets/source/img/img_Blog/';
      // $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
      // $config['file_name'] = $new_filename.'.png';
      // $config['max_size'] = 100000; //100MB

      // $this->load->library('upload', $config);

      // if (!$this->upload->do_upload('gambar')) {
      //   $msg = success_msg($this->upload->display_errors());
      //   $this->session->set_flashdata('message', $msg);
      //   if ($id == '') {
      //     redirect('adminstore/Blog/add/');
      //   }else{
      //     redirect('adminstore/Blog/detail/'.$id);
      //   }
      // };
      // $this->upload->do_upload('gambar2');

      // $data = array(
      //             'nama' => $nama,
      //             'deskripsi' => $deskripsi,
      //             'banner' => $new_filename.'.png',
      //             'updateBy' => $this->session->id_admin
      //           );
      // $proses = $this->Blog_model->update($id,$data);
      // }
      }

      if ($proses) {
        $msg = success_msg('Update berhasil!');
        $this->session->set_flashdata('message', $msg);
        if ($id == '') {
          redirect('adminstore/blog/add/');
        }else{
          redirect('adminstore/blog/detail/'.$id);
        }
      }else{
        $msg = error_msg('Gagal ubah Blog, pastikan data sudah benar!');
        $do = FALSE;
      }
      }

      if (!$do) {
            $this->session->set_flashdata('message', $msg);
            // log_history(current_url(), $msg);
            if ($id == '') {
              redirect('adminstore/blog/add/');
            }else{
              redirect('adminstore/blog/detail/'.$id);
            }
        }
	}

  public function archive($id){
    $data = array(
                  'active' => 0,
                  'deleteBy' => $this->session->id_admin,
                  'deleteDate' => date('YYYY-MM-DD hh:mm:ss')
                );
    $proses = $this->Blog_model->update($id,$data);

    if ($proses) {
      $msg = success_msg('Berhasil memindahkan Blog ke arsip!');
    }else{
      $msg = error_msg('Gagal memindahkan Blog ke arsip, pastikan data sudah benar!');
      $do = FALSE;
    }

    $this->session->set_flashdata('message', $msg);
    redirect('adminstore/Blog');
  }
}
