<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Users extends MY_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('master/User_model');
	}

	public function index()
	{
		$user = array('id_perusahaan' => $this->session->perusahaan['id_perusahaan']);

		$data['users'] = $this->User_model->getAll($user)->result();
		$data['title'] = 'Dashboard';
		$data['alert'] = $this->session->flashdata('message');
		$data['breadcrumb'] = $this->breadcrumb->generate();
		$data['contents'] = 'master/v_user';
		$this->load->view('layout/template', $data);
	}

	public function insert()
	{

		$user_name = $this->input->post('user_name');
		$user_pass = $this->input->post('user_pass');
		$id_max = $this->User_model->getIdMax()->row()->id_user;
		$aktif = boolval($this->input->post('aktif'));
		$id_perusahaan = $this->session->perusahaan['id_perusahaan'];
		$user = array(
			'id_user' => $id_max + 1,
			'user_name' => $user_name,
			'user_pass' => password_hash($user_pass, PASSWORD_BCRYPT),
			'aktif' => filter_var($aktif, FILTER_VALIDATE_BOOLEAN),
		);
		$perusahaan = array('id_user' => $id_max + 1, 'id_perusahaan' => $id_perusahaan);
		$user_perusahaan = $this->User_model->insertUserPerusahaan($perusahaan);

		$insert = $this->User_model->insertData($user);

		if ($insert != false && $user_perusahaan != false) {
			$output['success'] = true;
			$output['status'] = 1;
			$output['message'] = "Berhasil disimpan";
		} else {
			$output['success'] = false;
			$output['status'] = 2;
			$output['message'] = "Gagal disimpan";
		}
		echo json_encode($output);
	}


	public function update()
	{
		$id_user = $this->input->post('id_user');
		$aktif = $this->input->post('aktif');
		$user_pass = $this->input->post('user_pass');
		if ($user_pass != "") {
			$user = array(
				'user_name' => $this->input->post('user_name'),
				'user_pass' => password_hash($this->input->post('user_pass'), PASSWORD_BCRYPT),
				// 'user_pass' => $this->input->post('user_pass'),
				'aktif' => filter_var($aktif, FILTER_VALIDATE_BOOLEAN),
			);
		} else {
			$user = array(
				'user_name' => $this->input->post('user_name'),
				'aktif' => filter_var($aktif, FILTER_VALIDATE_BOOLEAN),
			);
		}
		$update = $this->User_model->updateData($id_user, $user);

		if ($update != false) {
			$output['success'] = true;
			$output['message'] = "Berhasil disimpan";
		} else {
			$output['success'] = false;
			$output['message'] = "Gagal disimpan";
		}
		echo json_encode($output);
	}


	public function delete()
	{
		$id_user = $this->input->post('id_user');
		$delete = $this->User_model->deleteData($id_user);

		if ($delete != false) {
			$output['success'] = true;
			$output['message'] = "Berhasil disimpan";
		} else {
			$output['success'] = false;
			$output['message'] = "Gagal disimpan";
		}
		echo json_encode($output);
	}
}
