<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Store extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->load->model('Produk_model');
	}
	
	public function index(){
		$data['title'] = 'Store';
		$data['contents'] = 'frontend/store/view';
		$this->load->view('frontend/layout/template', $data);
	}

	public function detail($slug=''){
		if ($slug=='') {
			redirect('404');
		}else{
			$where = array('slug' => $slug);
			$data['produk'] = $this->Produk_model->SelectWhere($where)->row();
		}
		$data['title'] = 'Store';
		$data['contents'] = 'frontend/store/detail';
		$this->load->view('frontend/layout/template', $data);
	}

	public function load_data(){
        // $this->load->model('scroll_pagination_model');
	    $keyword =  $this->input->post('keyword');
	    $urutharga =  $this->input->post('urutharga');
	    if ($keyword=='' && $urutharga=='') {
	        $data = $this->Produk_model->get_limit($this->input->post('limit'), $this->input->post('start'));
	        }else{
		      $this->form_validation->set_rules('keyword', 'Keyword', 'trim|xss_clean');
		      $this->form_validation->set_rules('urutharga', 'Urutan Harga', 'trim|xss_clean');

		      if($this->form_validation->run() == FALSE){
		          // $msg = error_msg(validation_errors());
		          $do = FALSE;
		      }else{
		          $do = TRUE;
		      }

		      if ($do) {
		      	$keyword2 = '%'.$keyword.'%';
		      	if ($urutharga == 1) {
		      		$urutharga = 'ASC';
		      	}else{
		      		$urutharga = 'DESC';
		      	}
		      	$data = $this->Produk_model->get_limit_keyword($this->input->post('limit'), $this->input->post('start'), $keyword2, $urutharga);
		      }
	      }

        $output = '';
	    foreach($data as $records){
	    	$output .= '<div class="col-md-3 w3ls_w3l_banner_left" style="margin-bottom: 20px;">
			<div class="hover14 column">
			<div class="agile_top_brand_left_grid w3l_agile_top_brand_left_grid">
				<div class="agile_top_brand_left_grid_pos">
					<img src="'.base_url('assets/source/img/img_produk/'.$records->gambar).'" alt=" " class="img-responsive" />
				</div>
				<div class="agile_top_brand_left_grid1">
					<figure>
						<div class="snipcart-item block">
							<div class="snipcart-thumb" style="height:250px">
								<a href="'.base_url('detail/'.$records->slug).'"><img src="'.base_url('assets/source/img/img_produk/'.$records->gambar).'" alt=" " class="img-responsive" />
								<p>'.substr($records->nama_produk, 0, 21);
								if (strlen($records->nama_produk) > 21) { $output .= "...";};
								$output .= '</p>';
								if ($records->diskon>0) {
									$diskon = $records->harga - ($records->harga * $records->diskon / 100);
									$output .= '<h4>Rp.'.number_format($diskon,0,',','.').' <span style="font-size:12px">Rp.'.number_format($records->harga,0,',','.').'</span></h4>';
								}else{
									$output .= '<h4>Rp.'.number_format($records->harga,0,',','.').'</h4>';
								}
							$output .='	
							</div>
							<div class="snipcart-details">
									<fieldset>
										<input type="hidden" name="cmd" value="_cart" />
										<input type="hidden" name="add" value="1" />
										<input type="hidden" name="business" value=" " />
										<input type="hidden" name="item_name" value="dishwash gel, lemon" />
										<input type="hidden" name="amount" value="8.00" />
										<input type="hidden" name="discount_amount" value="1.00" />
										<input type="hidden" name="currency_code" value="USD" />
										<input type="hidden" name="return" value=" " />
										<input type="hidden" name="cancel_return" value=" " />
										<input type="submit" name="submit" value="Lihat Dertail" class="button" /></a>
									</fieldset>
							</div>
						</div>
					</figure>
				</div>
			</div>
			</div>
		</div>';
	    }
	    echo $output;
    }
}
