<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Konfirm extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->load->model('Produk_model');
    $this->load->model('Order_model');
	}
	
  public function index($invoice=''){
    if ($invoice!='') {
      $data['order'] = $this->Order_model->select_invoice($invoice);
      if (isset($data['order'])) {
        $data['order_detail'] = $this->Order_model->select_id_order($data['order']->id_order);
      }else{
        $msg = error_msg('Nomor Invoice Tidak Ditemukan');
        $this->session->set_flashdata('message', $msg);
      }
    }
    $data['title'] = 'Konfirmasi Transfer';
    $data['alert'] = $this->session->flashdata('message');
    $data['contents'] = 'frontend/transaksi/konfirm';
    $this->load->view('frontend/layout/template', $data);
  }

 public function save(){
  $this->form_validation->set_rules('invoice', 'Invoice', 'trim|required|xss_clean');
    
    if($this->form_validation->run() == FALSE){
      $msg = error_msg(validation_errors());
      $this->session->set_flashdata('message', $msg);
      redirect('konfirm');
    }else{
      $do = TRUE;
    }

    if ($do) {
    $invoice = $this->input->post('invoice');
    $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $new_filename = substr(str_shuffle($permitted_chars), 0, 5).date("Ymdhi");

    $config['upload_path'] = './assets/source/img/img_buktitf/';
    $config['allowed_types'] = 'PNG|JPG|JPEG|png|jpg|jpeg';
    $config['file_name'] = $new_filename.'.png';
    $config['max_size'] = 100000; //100MB
    $this->load->library('upload', $config);
    $this->upload->initialize($config);
    $proses = $this->upload->do_upload('gambar');
    
    if ($proses) {
    $input = array(
        'buktitf' => $config['file_name']
        );
    $proses = $this->Order_model->update_invoice($invoice, $input);
    }
  
    if ($proses) {
        $msg = success_msg('Konfirmasi berhasil!');
        $this->session->set_flashdata('message', $msg);
      redirect('konfirm');
    }else{
        $msg = error_msg($this->upload->display_errors());
        $this->session->set_flashdata('message', $msg);
      redirect('konfirm');
    }
    }
  }
}
