<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Blog extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->load->model('Blog_model');
	}
	
	public function index(){
		$data['title'] = 'Blog';
		$data['contents'] = 'frontend/blog/view';
		$this->load->view('frontend/layout/template', $data);
	}

	public function detail($slug=''){
		if ($slug=='') {
			redirect('404');
		}else{
			$where = array('slug' => $slug);
			$data['blog'] = $this->Blog_model->SelectWhere($where)->row();
		}
		$data['title'] = 'Blog';
		$data['contents'] = 'frontend/blog/detail';
		$this->load->view('frontend/layout/template', $data);
	}

	public function load_data(){
        // $this->load->model('scroll_pagination_model');
	    $keyword =  $this->input->post('keyword');
	    if ($keyword=='') {
	        $data = $this->Blog_model->get_limit($this->input->post('limit'), $this->input->post('start'));
	        }else{
		      $this->form_validation->set_rules('keyword', 'Keyword', 'trim|xss_clean');

		      if($this->form_validation->run() == FALSE){
		          // $msg = error_msg(validation_errors());
		          $do = FALSE;
		      }else{
		          $do = TRUE;
		      }

		      if ($do) {
		      	$keyword2 = '%'.$keyword.'%';
		      	$data = $this->Blog_model->get_limit_keyword($this->input->post('limit'), $this->input->post('start'), $keyword2);
		      }
	      }

        $output = '';
	    foreach($data as $records){
	    	if (strlen($records->konten) > 200) { 
	    		$readmore = "...";
	    	}else{
	    		$readmore = "";
	    	}
	    	$output .= '<div class="col-md-12 w3ls_service_grid_left" style="margin-bottom:20px"><h4><a href="'.base_url('blog/detail/'.$records->slug).'">'.$records->judul.'</a></h4>
	    	<p>'.substr($records->konten, 0, 200).$readmore.'</p>
	    	</div>';
	    }
	    echo $output;
    }
}
