<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css"> -->


<div class="card col-sm-12">
	<div class="card-header">
		<h3 class="card-title">Data Rumah <?= $this->session->perusahaan["nama_perusahaan"]; ?></h3>
		<div class="card-tools">
			<div class="btn-group pull-left">
				<button type="button" class="btn btn-primary pull-left btn-xs" data-toggle="modal" data-target="#modal-rumah" onclick="tambah()">
					<i class="fa fa-plus"></i> Tambah
				</button>
			</div>
		</div>
	</div>
	<div class="card-body" style="align-items: center; ">
		<table id="table-rumah" class="display" style="width:100%">
			<thead>
				<tr>
					<th>No</th>
					<th>Kode Rumah</th>
					<th>Nama Pembeli</th>
					<th>Status</th>
					<th>Action</th>
				</tr>
			</thead>
			<tbody>
				<?php $no = 1;
				foreach ($rumah as $value) {
					// if ($value->nama_pembeli != null) {
					// 	$nama_pembeli = $value->nama_pembeli;
					// } else {
					// 	$nama_pembeli = "Belum ada pembeli";
					// } 
				?>
					<tr onclick="edit(<?= $value->id_rumah ?>)">

						<td><?= $no ?></td>
						<td><?= $value->kode_rumah; ?></td>
						<td><?= $value->nama_pembeli; ?></td>
						<!-- <td><?= $nama_pembeli; ?></td> -->
						<?php if ($value->status == 1) {
							$status = "AKAD & SKK";
						} else if ($value->status == 2) {
							$status = "HARD CASH";
						}
						else if ($value->status == 3) {
							$status = "INHOUSE LANCAR";
						}
						else if ($value->status == 4) {
							$status = "BLM LANCAR";
						}
						else if ($value->status == 5) {
							$status = "STOK RUMAH";
						}
						else {
							$status = "STOK RWU (RUKO)";
						}
						?>
						<td><?= $status ?></td>
						<td><button class="btn btn-success btn-xs btn-edit" value="<?= $no ?>" id="edit"> <i class="glyphicon glyphicon-trash"></i> edit</button>
							<button class="btn btn-danger btn-xs" onclick="hapus(<?= $value->id_rumah ?>)" id="hapus"> <i class="glyphicon glyphicon-trash"></i> hapus</button></td>
					</tr>
				<?php $no++;
				} ?>
			</tbody>
		</table>
	</div>
</div>
<div class="modal fade" id="modal-rumah">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Form Rumah</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<form class="form-horizontal">
				<div class="card-body">
					<div class="form-group row">
						<label class="col-sm-4 col-form-label">Kode Rumah</label>
						<div class="col-sm-8">
							<input type="text" class="form-control" id="kode_rumah" placeholder="Masukkan Kode Rumah">
						</div>
					</div>
					<div class="form-group row">
						<label class="col-sm-4 col-form-label">Nama Pembeli</label>
						<div class="col-sm-8">
							<input type="text" class="form-control" id="nama_pembeli" placeholder="Masukkan Nama Pembeli">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-sm-4 col-form-label">Status</label>
						<div class="col-sm-8">
							<select class="form-control" id="status" name="status">
								<option value="1">AKAD & SKK</option>
								<option value="2">HARD CASH</option>
								<option value="3">INHOUSE LANCAR</option>
								<option value="4">BLM LANCAR</option>
								<option value="5">STOK RUMAH</option>
								<option value="6">STOK RWU (RUKO)</option>
							</select>
						</div>
					</div>

					<div class="form-group row">
						<div class="offset-sm-4 col-sm-8">
							<div class="form-check">
								<input type="checkbox" class="form-check-input" id="exampleCheck2" checked>
								<label class="form-check-label" for="exampleCheck2">Active</label>
							</div>
						</div>
					</div>
				</div>

			</form>
			<div class="offset-sm-1 col-sm-10" id="alert-success">
				<div class="alert alert-success alert-dismissible pull-center">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
					<div class="text-center">
						<div id="msg" class="text-center">Data berhasil disimpan</div>
					</div>
				</div>
			</div>
			<div class="offset-sm-1 col-sm-10" id="alert-denied">
				<div class="alert alert-danger alert-dismissible pull-center">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
					<div class="text-center" id="msg">Nama perusahaan tidak boleh kosong</div>
				</div>
			</div>
			<div class="modal-footer justify-content-between">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				<button type="button" class="btn btn-primary" onclick="simpan()">Save</button>
			</div>
		</div>
	</div>
</div>
<script>
	var url;
	var id_rumah;
	$(document).ready(function() {
		$('#alert-denied').hide();
		$('#alert-success').hide();
		$('#table-rumah').DataTable({
			scrollY: "300px",
			scrollX: true,
			scrollCollapse: true,
			paging: true,
			columnDefs: [{
				width: 100,
				targets: 0,
			}],
			fixedColumns: true
		});
	});


	$(".btn-edit").click(function() {
		var table = $('#table-rumah').DataTable();
		var id = $(this).val();
		document.getElementById("kode_rumah").value = table.row(id - 1).data()[1];
		document.getElementById("nama_pembeli").value = table.row(id - 1).data()[2];
		$('#modal-rumah').modal('show');
	});

	function tambah() {
		url = "<?= base_url('/Rumah/insert') ?>";
	}

	function edit(id) {
		var table = $('#table-rumah').DataTable();

		$('#table-rumah tbody').on('dblclick', 'tr', function() {
			document.getElementById("kode_rumah").value = table.row(this).data()[1];
			document.getElementById("nama_pembeli").value = table.row(this).data()[2];
			$('#modal-rumah').modal('show');
		});
		url = "<?= base_url('/Rumah/update') ?>";
		id_rumah = id; // tidak bisa sama
	}

	function simpan() {

		var name = $('#nama_pembeli').val();
		var kode_rumah = $('#kode_rumah').val();
		var status = $('#status').val();

		$.ajax({
			type: "POST",
			url: url,
			data: {
				id_perusahaan: <?= $this->session->userdata('perusahaan')["id_perusahaan"]; ?>,
				kode_rumah: kode_rumah,
				nama_pembeli: name,
				id_rumah: id_rumah,
				status: status,
			},
			success: function(data) {
				alert("berhasil disimpan");
				location.reload();
				$('#modal-rumah').modal('hide');
			}
		});
	}

	function hapus(id_rumah) {
		if (confirm("Hapus rumah ? ")) {
			$.ajax({
				type: "POST",
				url: '<?= base_url('Rumah/delete') ?>',
				data: {
					id_rumah: id_rumah,
				},
				success: function(data) {
					alert("berhasil dihapus");
					location.reload();
				}
			});

		} else {
			// alert("reload");
			// location.reload();
		}




	}
</script>
