<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<div class="card col-sm-12" style="height: 100%;">
	<div class="card-header">
		<h3 class="card-title">Daftar Perusahaan <?= $this->session->perusahaan["nama_perusahaan"]; ?></h3>
		<div class="card-tools">
			<div class="btn-group pull-left">
				<button type="button" class="btn btn-primary pull-left btn-xs" data-toggle="modal" data-target="#modal" onclick="tambah()">
					<i class="fa fa-plus"></i> Tambah
				</button>
			</div>
		</div>
	</div>

	<div class="card-body col-sm-6" style="align-items: center; ">
		<div>
			<table id="table-perusahaan" name="table-perusahaan" class="table table-bordered table-striped">

				<thead>
					<tr>
						<th>No</th>
						<th>Nama Perusahaan</th>
						<th style="width:50%" hidden>Username</th>
						<th>Action</th>
					</tr>
				</thead>

				<tbody>
					<?php $no = 1;
					foreach ($perusahaan as $value) { ?>
						<tr onclick="edit()" id="tr-table">
							<td><?= $no ?></td>
							<td hidden><?= $value->id_perusahaan; ?></td>
							<td><?= $value->nama_perusahaan; ?></td>
							<td><button class="btn btn-success btn-xs btn-edit" value="<?= $no ?>"> <i class="glyphicon glyphicon-trash"></i> edit</button>
								<button class="btn btn-danger btn-xs" onclick="hapus(<?= $value->id_perusahaan ?>)"> hapus</button></td>
						</tr>
					<?php $no++;
					} ?>
				</tbody>
			</table>
		</div>
	</div>

</div>

<div class="modal fade" id="modal">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Form Perusahaan</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<!-- <div class="card-body"> -->
				<div class="col-sm-12" id="alert-success">
					<div class="alert alert-success alert-dismissible pull-center">
						<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
						<div class="text-center">
							<div id="msg" class="text-center">Data berhasil disimpan</div>
						</div>
					</div>
				</div>
				<div class="offset-sm-1 col-sm-10" id="alert-denied">
					<div class="alert alert-danger alert-dismissible pull-center">
						<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
						<div class="text-center" id="msg">Nama perusahaan tidak boleh kosong</div>
					</div>
				</div>
				<form class="form-perusahaan" id="form-perusahaan">
					<input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>" style="display: none">
					<div class="form-group row">
						<label class="col-sm-4 col-form-label">Nama Perusahaan</label>
						<div class="col-sm-8">
							<input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" placeholder="Masukkan Nama Perusahaan">
						</div>
					</div>

					<div class="form-group row">
						<div class="offset-sm-4 col-sm-10">
							<div class="form-check">
								<input type="checkbox" class="form-check-input" id="aktif" name="aktif" checked>
								<label class="form-check-label" for="exampleCheck2">Active</label>
							</div>
						</div>
					</div>

				</form>

			</div>
			<div class="modal-footer justify-content-between">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				<button type="submit" class="btn btn-primary" onclick="simpan()">Save</button>
			</div>

		</div>
	</div>
</div>
<script>
	$(document).ready(function() {
		$('#table-perusahaan').DataTable({
			scrollY: "300px",
			scrollX: false,
			scrollCollapse: true,
			paging: true,
			columnDefs: [{
				width: 100,
				targets: 0,
			}],
			fixedColumns: true
		});
	});
	$(".btn-edit").click(function() {
		var table = $('#table-perusahaan').DataTable();
		var id = $(this).val();
		document.getElementById("nama_perusahaan").value = table.row(id - 1).data()[2];
		$('#modal').modal('show');
		id_perusahaan = table.row(id - 1).data()[1];
		url = "<?= base_url('/Perusahaan/update') ?>";
	});

	var url, id_perusahaan;
	$('#alert-denied').hide();
	$('#alert-success').hide();

	function tambah() {
		url = "<?= base_url('/Perusahaan/insert') ?>";
	}


	function edit() {
		var table = $('#table-perusahaan').DataTable();
		$('#table-perusahaan tbody').on('dblclick', 'tr', function() {
			document.getElementById("nama_perusahaan").value = table.row(this).data()[1];
			$('#modal').modal('show');
			id_perusahaan = table.row(this).data()[0];

		});

		url = "<?= base_url('/Perusahaan/update') ?>";
	}

	function simpan() {
		var name = $('#nama_perusahaan').val();
		$.ajax({
			type: "POST",
			dataType: 'json',
			url: url,
			data: {
				nama_perusahaan: name,
				id_perusahaan: id_perusahaan,
			},
			success: function(data) {
				if (data.success) {
					$('#alert-denied').hide();
					$('#alert-success').show();
					alert(data.message);
					location.reload();

				} else {
					if (data.status == 3) {
						$('#alert-success').hide();
						$('#alert-denied').show();
					} else {
						alert("data gagal disimpan");
					}

				}
			}
		});
	}

	function hapus(id_perusahaan) {
		if (confirm("Hapus perusahaan ? ")) {
			$.ajax({
				type: "POST",
				url: '<?= base_url('Perusahaan/delete') ?>',
				data: {
					id_perusahaan: id_perusahaan,
				},
				success: function(data) {
					alert("Berhasil dihapus");
					location.reload();
				}
			});
		} else {
			alert("reload");
			location.reload();
		}
	}
</script>
