<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>

<style>
	.select2-container .select2-selection--single {
		height: 34px !important;
	}

	.select2-container--default .select2-selection--single {
		border: 1px solid #ccc !important;
		border-radius: 0px !important;
	}

	.select3-container .select3-selection--single {
		height: 34px !important;
	}

	.select3-container--default .select3-selection--single {
		border: 1px solid #ccc !important;
		border-radius: 0px !important;
	}
</style>

<div id='formData'>
	<div id="formData">
		<div class="card-header">
			<h3 class="card-title"> Form Lapor Proyek </h3>
		</div>
		<div class="card-body">
			<form enctype="multipart/form-data" accept-charset="utf-8" name="formname" id="formname" method="post" action="">
				<div class="col-sm-12" id="alert-success1">
					<div class="alert alert-success alert-dismissible pull-center">
						<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
						<div class="text-center">
							<div id="msg11" class="text-center"></div>
						</div>
					</div>
				</div>
				<div class="offset-sm-1 col-sm-10" id="alert-denied1">
					<div class="alert alert-danger alert-dismissible pull-center">
						<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
						<div id="msg_danger" class="text-center"></div>
					</div>
				</div>
				<div class="form-group row">
					<label for="inputEmail3" class="col-sm-3 col-form-label">Blok Rumah</label>
					<div class="col-sm-2" id="row-rumah">
						<select style="width: 250px;" class="form-control select2" id="id_rumah" name="id_rumah">
							<?php $no = 1;
							foreach ($rumah as $value) { ?>
								<option value="<?= $value->id_rumah ?>"><?= $no . '. ' . $value->kode_rumah ?></option>
							<?php $no++;
							} ?>
						</select>
					</div>
					<div id="id2_rumah" name="id2_rumah" style="padding-top:8px; padding-left: 5px;"></div>
				</div>
				<div class=" form-group row">
					<label for="inputPassword3" class="col-sm-3 col-form-label">Menu</label>
					<div class="col-sm-2" id="row-menu">
						<select style="width: 250px;" class="form-control select3" id="id_menu" name="id_menu">
							<option value='0'>--pilih--</option>
						</select>
					</div>
					<div id="id2_menu" name="id2_menu" style="padding-top:8px; padding-left: 5px;"></div>

				</div>
				<div class="form-group row">
					<label class="col-sm-3 col-form-label">Tanggal</label>
					<div class="col-sm-8">
						<input type="date" class="form-control" id="tgl_trans" name="tgl_trans" value="<?= Date('Y-m-d') ?>" placeholder="Masukkan Nama Pembeli">
					</div>
				</div>
				<div class="form-group row" id="row-sdm">
					<label class="col-sm-3 col-form-label">Jumlah Orang</label>
					<div class="col-sm-8">
						<input type="number" class="form-control" id="jml_org" name="jml_org" placeholder="Masukkan Jumlah Orang">
					</div>
				</div>

				<div class="form-group row" id="uploadFile">
					<label for="inputPassword3" class="col-sm-3 col-form-label">Upload File</label>
					<div class="col-sm-8">
						<div class="custom-file">
							<!-- <input type="file" id="path_file" name="path_file"> -->
							<input type="file" class="custom-file-input" id="path_file" name="path_file" onchange="ubahPhoto()" accept="application/pdf">
							<label class=" custom-file-label text-foto" for="exampleInputFile">Choose file</label>
						</div>
					</div>
				</div>
				<div class="text-center">
					<div class="spinner-border" role="status" id="progress">
						<span class="sr-only">Loading...</span>
					</div>
				</div>

				<div class="form-group row">
					<div class="col-sm-12">
						<label for="inputPassword3" class="col-sm-3 col-form-label"></label>
						<button type="button" class="btn btn-info" onclick="lapor()" id="save">Lapor</button>
						<button type="button" class="btn btn-default" id="btn-cancel">Cancel</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>

<div class="modal fade" id="form-lapor">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Form Perusahaan</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>

			<div class="modal-body">
				<div class="card-body">
					<div class="col-sm-12" id="alert-success-edit">
						<div class="alert alert-success alert-dismissible pull-center">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
							<div class="text-center">
								<div id="msg" class="text-center">Data berhasil disimpan</div>
							</div>
						</div>
					</div>
					<div class="offset-sm-1 col-sm-10" id="alert-denied-edit">
						<div class="alert alert-danger alert-dismissible pull-center">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
							<div class="text-center" id="msg">Nama perusahaan tidak boleh kosong</div>
						</div>
					</div>
					<form class="form-perusahaan" id="form-perusahaan">
						<div class="form-group row">
							<label for="inputEmail3" class="col-sm-3 col-form-label">Blok Rumah</label>
							<div class="col-sm-8">
								<div id="edit_rumah" style="padding-top:8px; padding-left: 5px;"></div>
							</div>
						</div>
						<div class=" form-group row">
							<label for="inputPassword3" class="col-sm-3 col-form-label">Menu</label>
							<div class="col-sm-8">
								<div id="edit_menu" style="padding-top:8px; padding-left: 5px;"></div>
							</div>
						</div>
						<div class="form-group row">
							<label class="col-sm-3 col-form-label">Tanggal</label>
							<div class="col-sm-8">
								<input type="date" class="form-control" id="edit_trans" name="edit_trans" value="<?= Date('Y-m-d') ?>" placeholder="Masukkan Nama Pembeli">
							</div>
						</div>
						<div class="form-group row" id="row-edit-sdm">
							<label class="col-sm-3 col-form-label">Jumlah Orang</label>
							<div class="col-sm-8">
								<input type="number" class="form-control" id="jml_org" name="jml_org" placeholder="Masukkan Jumlah Orang">
							</div>
						</div>
						<div class="form-group row" id="row-edit-pic">
							<label for="inputPassword3" class="col-sm-3 col-form-label">Upload File</label>
							<div class="col-sm-8">
								<div class="custom-file">
									<input type="file" id="path_file_edit" name="path_file_edit" onchange="ubahPhoto()" accept="application/pdf">
								</div>
							</div>
						</div>
						<div class="form-group row">
							<div class="col-sm-12">
								<label for="inputPassword3" class="col-sm-3 col-form-label"></label>
								<button type="submit" class="btn btn-info" onclick="lapor()" id="save">Lapor</button>
								<button type="submit" class="btn btn-default ">Reset</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
	$("#btn-cancel").click(function() {
		location.reload();
	});

	$('#progress').hide();
	$('#alert-denied1').hide();
	$('#row-sdm').hide();
	$('#edit-hari').hide();
	$('#alert-success1').hide();
	$('#alert-denied-edit').hide();
	$('#alert-success-edit').hide();
	$('.select2').select2();
	$('.select3').select2();

	var rumah;
	url = "<?= base_url("Lapor/insert") ?>";

	// get combo box rumah pertama di perusahaan
	$(document).ready(function() {
		$.ajax({
			url: '<?= base_url('Rumah/getRumah') ?>',
			cache: false,
			type: 'post',
			data: {
				id_perusahaan: <?= $this->session->perusahaan["id_perusahaan"]; ?>,
			},
			success: function(respond) {
				rumah = respond;
				// alert(rumah);
			}
		});
		$.ajax({
			url: '<?= base_url('Menu/getMenu') ?>',
			cache: false,
			type: 'post',
			data: {
				id_rumah: 1,
			},
			success: function(respond) {
				$("#id_menu").html(respond);
			}
		});
	});

	$("#id_rumah").change(function() {
		var value = $(this).val();
		if (value > 0) {
			$.ajax({
				url: '<?= base_url('Menu/getMenu') ?>',
				cache: false,
				type: 'post',
				data: {
					id_rumah: value,
				},
				success: function(respond) {
					$("#id_menu").html(respond);
					rumah = $('#id_rumah').val();
				}
			})
		}
	});

	function ubahPhoto() {
		name = $('#path_file').prop('files')[0].name;
		new_name = name.substring(0, 13)
		$('.text-foto').text(new_name + "....pdf");
	}

	$("#id_menu").change(function() {
		var menu = $(this).val();

		result = $('#id_menu  option:selected').text();
		kategori = result.substring(result.indexOf(".") + 1, result.length);

		if (kategori == 'MEP' || kategori == 'STRUKTUR' || kategori == 'ARSITEKTUR') {
			$('#row-sdm').show();
			$('#uploadFile').hide();
		} else {
			$('#row-sdm').hide();
		}

		$.ajax({
			url: '<?= base_url('Lapor/cekLapor') ?>',
			dataType: 'json',
			cache: false,
			type: 'post',
			data: {
				id_rumah: rumah,
				id_menu: menu,
			},
			success: function(respond) {
				$('#edit_rumah').text($("#id_rumah option:selected").text());
				$('#edit_menu').text($("#id_menu option:selected").text());;
				if (respond) {
					if (menu >= 24) {
						$('#row-edit-pic').hide();
						$('#row-edit-sdm').show();

					} else {
						$('#row-edit-sdm').hide();
						$('#row-edit-pic').show();
					}
					if (confirm("Data sudah dilaporkan, edit ?")) {
						url = "<?= base_url("Lapor/update") ?>";



						$('#form-lapor').modal('show');

					}
				}

			}
		})
	});

	function addPhoto() {
		name = $('#path_file').prop('files')[0].name;
		$('.text-foto').text(name);
	}

	function lapor() {
		$('#progress').show();
		var cek = url.indexOf("insert");
		var jml = $('#jml_hari').val();
		var id = $('#id_rumah').val();
		// var pesan = "Anda yakin ingin mengupload menu " + $('#id_menu option:selected').text() + " di blok " + $('#id_rumah option:selected').text() + " ? ";
		// alert(pesan.bold());
		if (confirm("Anda yakin ingin mengupload menu <bold>" + $('#id_menu option:selected').text() + " di blok " + $('#id_rumah option:selected').text() + " ?")) {
			if ($('#id2_rumah').val() == "" || $('#id2_menu').val() == 0) {
				if ($('#id_rumah').val() == "" || $('#id_menu').val() == 0) {
					$('#alert-denied1').show();
				} else {
					if (cek > 0) {
						gbr = $('#path_file').prop('files')[0];
					} else {
						gbr = $('#path_file_edit').prop('files')[0];
					}
					// alert("insert");

					var form_data = new FormData();
					form_data.append('id_rumah', $('#id_rumah').val());
					form_data.append('id_menu', $('#id_menu').val());
					form_data.append('jml_org', $('#jml_org').val());
					form_data.append('tgl_trans', $('#tgl_trans').val());
					form_data.append('path_file', gbr);

					$.ajax({
						url: url,
						dataType: 'json',
						data: form_data,
						cache: false,
						contentType: false,
						processData: false,
						type: 'post',
						beforeSend: function() {
							$('#save').attr('disabled', 'disabled');
							$('#progress').show();

						},
						success: function(data) {
							if (data.success) {
								$('#alert-success1').hide();
								$('#msg11').text(data.message);
								$('#alert-success1').show();
								alert(data.message); //penting jangan dihapus
								location.reload();
							} else {
								$('#alert-denied1').hide();
								$('#msg_danger').text(data.message);
								$('#alert-denied1').show();
								alert(data.message); //penting jangan dihapus
								location.reload();

							}
						}
					});
				}
			} else {
				var form_data = new FormData();
				form_data.append('id_rumah', $('#id2_rumah').val());
				form_data.append('id_menu', $('#id2_menu').val());
				form_data.append('tgl_trans', $('#tgl_trans').val());
				form_data.append('jml_org', $('#jumlah_baru').val());
				form_data.append('path_file', $('#path_file').prop('files')[0]);

				$.ajax({
					url: url,
					dataType: 'json',
					data: form_data,
					cache: false,
					contentType: false,
					processData: false,
					type: 'post',
					beforeSend: function() {
						$('#save').attr('disabled', 'disabled');
						$('#progress').show();
					},
					success: function(data) {

						if (data.success) {
							$('#alert-success1').hide();
							$('#msg11').text(data.message);
							$('#alert-success1').show();
							alert(data.message);
							location.reload();
						} else {
							$('#alert-denied1').hide();
							$('#msg_danger').text(data.message);
							$('#alert-denied1').show();
							alert(data.message);
							location.reload();
						}
					}
				});
			}
		} else {
			$('#progress').hide();
		}
	}
</script>
