<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Auth extends CI_Controller
{

	public function index()
	{
		if (isset($this->session->username) && $this->session->id_user > -1) {
			redirect('Home');
		} else {
			$this->session->sess_destroy();
			$data['title'] = 'Login';
			$data['alert'] = $this->session->flashdata('message');
			$this->load->view('page/login', $data);
		}
	}

	public function login()
	{
		$this->load->model('master/User_model');

		$this->form_validation->set_rules('user_name', 'Username', 'trim|required|xss_clean');
		$this->form_validation->set_rules('user_pass', 'Password', 'trim|required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$msg = error_msg(validation_errors());
			$do = FALSE;
		} else {
			$do = TRUE;
		}

		$username = $this->input->post('user_name');
		$password = $this->input->post('user_pass');

		if ($do) {
			// get user
			$user = $this->User_model->getKode($username);

			if ($user['id_user'] == '' or $user['id_user'] == null) {
				$msg = error_msg('User tidak ditemukan');
				$do = false;
				// } else if ($user['active'] == 0) {
			} else if ($user['aktif'] == 0) {
				$msg = error_msg('User tidak aktif, hubungi admin untuk lebih lanjut');
				$do = false;
			}
			else {
				// if (password_verify($password,$user['password'])){
				if (password_verify($password, $user['user_pass'])) {
					$newdata = array(
						'id_user' => $user['id_user'],
						'user_name' => $user['user_name'],
					);

					// $hakAkses = $this->User_model->selectAkses($user['id_user']);

					// $aksesThing = array(
					// 	'hakAkses' => $hakAkses,
					// );

					// $newdata = array_merge($newdata, $aksesThing);

					// $this->session->set_userdata('hakAkses', $hakAkses);
					$this->session->set_userdata($newdata);

					// log_history(current_url(), 'berhasil login');
					redirect('home');
				} else {
					$msg = error_msg('Password salah');
					$do = false;
				}
			}
		}

		if (!$do) {
			$this->session->set_flashdata('message', $msg);

			// log_history(current_url(), 'gagal login');
			redirect('auth');
		}
	}

	public function logout()
	{
		// log_history(current_url(), 'logout');

		$this->session->sess_destroy();

		redirect();
	}
}
